function update(dt)      
        local gearText = tostring(car.gear) -- needs to be converted so that neutral and reverse display correctly (-1 = R, 0 = N)
        if car.gear == -1 then
            gearText = "R"
        end
        if car.gear == 0 then
            gearText = "N"
        end
        
        display.text {
            text = gearText,
            pos = vec2(217, 4),
            letter = vec2(20, 30),
            font = "digital_big",
            width = 0.5,
            alignment = 0,
            spacing = -1.0
        }    
        
        display.text{
            text = "TRIP",
            pos = vec2(205, 220),
            letter = vec2(10, 15),
            font = "digital_big",
            color = rgbm(5,5,5,1), 
            width = 0.5,
            spacing = 0,
            alignment = -1.0
            }

        display.text{
            text = "KM",
            pos = vec2(10, 220),
            letter = vec2(10, 15),
            font = "digital_big",
            color = rgbm(5,5,5,1), 
            width = 0.5,
            spacing = 0,
            alignment = -1.0
            }   
        
        display.text{
            text = "km/h",
            pos = vec2(185, 120),
            letter = vec2(15, 25),
            font = "digital_big",
            color = rgbm(5,5,5,1), 
            width = 0.5,
            spacing = 0,
            alignment = -1.0
            }
    
        local temperature = ac.getSimState().ambientTemperature
	
            display.text{
                text = math.floor(temperature),
                pos = vec2(110, 190),
                letter = vec2(20, 27),
                font = "digital_big",
                color = rgbm(5,5,5,1)  
                
            }  
            
            display.text{
                text = "c",
                pos = vec2(156, 193),
                letter = vec2(18, 22),
                font = "digital_big",
                color = rgbm(5,5,5,1), 
                width = 0.3,
                spacing = 0,
                alignment = 0.5
            }

            display.text{ 
                text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
                pos = vec2(10, 8),
                letter = vec2(17, 22),
                font = "digital_big",
                color = rgbm.from0255(500,500,500,1)  
            }
            
            display.text{
                text = string.format("%0.1f", car.distanceDrivenTotalKm),
                clampMax = 999999,
                pos = vec2(6, 233),
                letter = vec2(11, 18),
                font = "digital_big",
                color = rgbm(5,5,5,1), 
                width = 200,
                spacing = 0,
                alignment = 0
            }
            
            display.text{
                text = string.format("%0.0f", car.distanceDrivenSessionKm),
                clampMax = 999,
                pos = vec2(210, 233),
                letter = vec2(11, 18),
                font = "digital_big",
                color = rgbm(5,5,5,1), 
                width = 35,
                spacing = 0,
                alignment = 1
            }

            digitCoords = {
                -- define your coords here
                vec2(45, 86), -- the leftmost digit
                vec2(88, 86), -- the center digit
                vec2(130, 86), -- the rightmost digit
                vec2(88, 86), -- the center digit
                vec2(130, 86)  -- the rightmost digit
            }    
            
            -- preparing our table of speed digits
    local displayspeed = tostring(math.floor(car.poweredWheelsSpeed)) -- math.floor rounds to the next full number
    local speedTable = {}
    for i = 1, string.len(displayspeed) do
        speedTable[i] = displayspeed:sub(i, i)
    end
    if string.len(displayspeed) == 1 then
        display.text {
            -- rightmost digit
            text = speedTable[1],
            pos = digitCoords[3],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
    elseif string.len(displayspeed) == 2 then
        display.text {
            -- rightmost digit
            text = speedTable[2],
            pos = digitCoords[5],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
        display.text {
            -- center digit
            text = speedTable[1],
            pos = digitCoords[4],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
    elseif string.len(displayspeed) == 3 then
        display.text {
            -- rightmost digit
            text = speedTable[3],
            pos = digitCoords[3],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
        display.text {
            -- center digit
            text = speedTable[2],
            pos = digitCoords[2],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
        display.text {
            -- leftmost digit
            text = speedTable[1],
            pos = digitCoords[1],
			letter = vec2(50, 70),
			font = "digital_big",
			color = rgbm(5,5,5,1), 
			width = 0.5,
			spacing = 0,
			alignment = -1.0
        }
    end
end